Triggers = {}

function Triggers.idle()
	enemy_Collision()
	player_Collision()
end

function enemy_Collision()
	for P in Players() do
		for M in Monsters() do
			if M.player == nil then
				rdus = M.type.radius + 0.500
				ttrd = (0.204 + M.type.radius + 0.250)^2				--0.204:player radius			0.250:margin(any value)
				dist = (P.x - M.x)^2 + (P.y - M.y)^2 + (P.z - M.z)^2
				
				if dist <= ttrd then
					dx = (P.x - M.x)
					dy = (P.y - M.y)
					dz = (P.z - M.z)
					deg = math.sqrt(dx^2 + dy^2 + dz^2)
					
					mvx = (dx/deg)*rdus
					mvy =	(dy/deg)*rdus
					mvz =	(dz/deg)*rdus
					
					P:position(M.x+mvx,M.y+mvy,M.z-mvz,P.polygon)
				end
			end
		end
	end
end

function player_Collision()
	for P in Players() do
		for M in Players() do
			if M ~= P and M.dead ~= true then
			rdus = 0.204 + 0.500
			ttrd = (0.204 + 0.204 + 0.250)^2
			dist = (P.x - M.x)^2 + (P.y - M.y)^2 + (P.z - M.z)^2
			
			if dist <= ttrd then
				dx = (P.x - M.x)
				dy = (P.y - M.y)
				dz = (P.z - M.z)
				deg = math.sqrt(dx^2 + dy^2 + dz^2)
				
				mvx = (dx/deg)*rdus
				mvy =	(dy/deg)*rdus
				mvz =	(dz/deg)*rdus
				
				P:position(M.x+mvx,M.y+mvy,P.z,P.polygon)
				end
			end
		end
	end
end